<?php

require_once "db_con_live_static.php";
require_once('config_alin.php');

// ini_set('display_errors', '1');
// ini_set('display_startup_errors', '1');
// error_reporting(E_ALL);


header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=UTF-8');

// Get input data
$input_data = json_decode(file_get_contents("php://input"));

// Retrieve parameters from the request
$username = $input_data->Username ?? '';
$password = $input_data->Password ?? '';
$from ='ALIN FOODS';
$to = $input_data->To ?? '';
$message = $input_data->Message ?? '';
$cid = $input_data->cid ?? '';
$ip = $input_data->ip ?? '';

// Additional parameters for new API
$msgType = $input_data->msgType ?? 'T'; // T=transactional, P=promotional
$contentType = $input_data->contentType ?? 1; // 1=Regular, 2=Unicode
$requestType = $input_data->requestType ?? 'S'; // S=single, B=bulk

// Validate required fields
if (empty($username) || empty($password) || empty($from) || empty($to) || empty($message)) {
    header("HTTP/1.1 400 Bad Request");
    echo json_encode([
        'error' => 'Missing required parameters',
        'required' => ['Username', 'Password', 'From', 'To', 'Message']
    ]);
    exit();
}

// Verify username and password
if ($username !== 'fahimerp' || $password !== '35ggh7') {
    header("HTTP/1.1 401 Unauthorized");
    echo json_encode(['error' => 'Unauthorized access']);
    exit();
}

// Function to make HTTP requests
function makeRequest($url, $data = null, $headers = []) {
    $curl = curl_init();
    
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_HTTPHEADER => $headers
    ]);
    
    if ($data) {
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
    }
    
    $response = curl_exec($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($curl);
    curl_close($curl);
    
    return [
        'response' => $response,
        'http_code' => $http_code,
        'error' => $curl_error
    ];
}

// Step 1: Get authentication token
$token_url = 'https://api.mobireach.com.bd/auth/tokens';
$token_data = [
    'username' => $config['username'],
    'password' => $config['password']
];

$token_headers = [
    'Content-Type: application/json'
];

$token_result = makeRequest($token_url, $token_data, $token_headers);

if ($token_result['error']) {
    $error_response = [
        'error' => 'Token request failed: ' . $token_result['error'],
        'http_code' => $token_result['http_code']
    ];
    
    // Log error to database
    // $error_status = 'Token Error: ' . $token_result['error'];
    // $query = 'INSERT INTO sms_api_info (cid, username, password, fromNumber, toNumber, message, status, ip_address) VALUES ("'.$cid.'","'.$username.'", "'.$password.'", "'.$from.'", "'.$to.'", "'.$message.'", "'.$error_status.'","'.$ip.'")';
    // mysqli_query($new_conn, $query);
    
    header("HTTP/1.1 500 Internal Server Error");
    echo json_encode($error_response);
    exit();
}

// Parse token response
$token_response = json_decode($token_result['response'], true);

if (!$token_response || !isset($token_response['token'])) {
    $error_response = [
        'error' => 'Failed to get authentication token',
        'api_response' => $token_result['response'],
        'http_code' => $token_result['http_code']
    ];
    
    // Log error to database
    // $error_status = 'Token Parse Error';
    // $query = 'INSERT INTO sms_api_info (cid, username, password, fromNumber, toNumber, message, status, ip_address) VALUES ("'.$cid.'","'.$username.'", "'.$password.'", "'.$from.'", "'.$to.'", "'.$message.'", "'.$error_status.'","'.$ip.'")';
    // mysqli_query($new_conn, $query);
    
    header("HTTP/1.1 500 Internal Server Error");
    echo json_encode($error_response);
    exit();
}

$access_token = $token_response['token'];
$refresh_token = $token_response['refresh_token'];

// Step 2: Send SMS using the token
$sms_url = 'https://api.mobireach.com.bd/sms/send';

// Prepare receiver array - handle both single and multiple numbers
$receivers = [];
if (strpos($to, ',') !== false) {
    // Multiple numbers separated by comma
    $receivers = explode(',', $to);
    $receivers = array_map('trim', $receivers);
    $requestType = 'B'; // Bulk
} else {
    // Single number
    $receivers = [$to];
    $requestType = 'S'; // Single
}

$sms_data = [
    'sender' => $from,
    'receiver' => $receivers,
    'contentType' => (int)$contentType,
    'content' => $message,
    'msgType' => $msgType,
    'requestType' => $requestType
];

$sms_headers = [
    'Content-Type: application/json',
    'Authorization: Bearer ' . $access_token
];

$sms_result = makeRequest($sms_url, $sms_data, $sms_headers);

if ($sms_result['error']) {
    $error_response = [
        'error' => 'SMS request failed: ' . $sms_result['error'],
        'http_code' => $sms_result['http_code']
    ];
    
    // Log error to database
    // $error_status = 'SMS Error: ' . $sms_result['error'];
    // $query = 'INSERT INTO sms_api_info (cid, username, password, fromNumber, toNumber, message, status, ip_address) VALUES ("'.$cid.'","'.$username.'", "'.$password.'", "'.$from.'", "'.$to.'", "'.$message.'", "'.$error_status.'","'.$ip.'")';
    // mysqli_query($new_conn, $query);
    
    header("HTTP/1.1 500 Internal Server Error");
    echo json_encode($error_response);
    exit();
}

// Parse SMS response
$sms_response = json_decode($sms_result['response'], true);

if (!$sms_response) {
    $error_response = [
        'error' => 'Failed to parse SMS response',
        'raw_response' => $sms_result['response'],
        'http_code' => $sms_result['http_code']
    ];
    
    // Log error to database
    // $error_status = 'SMS Parse Error';
    // $query = 'INSERT INTO sms_api_info (cid, username, password, fromNumber, toNumber, message, status, ip_address) VALUES ("'.$cid.'","'.$username.'", "'.$password.'", "'.$from.'", "'.$to.'", "'.$message.'", "'.$error_status.'","'.$ip.'")';
    // mysqli_query($new_conn, $query);
    
    header("HTTP/1.1 500 Internal Server Error");
    echo json_encode($error_response);
    exit();
}

// Handle different response formats
$status_text = 'success';
$message_id = '';
$error_code = 0;

// Check if there's an error in the response
if (isset($sms_response['error'])) {
    $status_text = $sms_response['error'];
    $error_code = $sms_result['http_code'];
} elseif (isset($sms_response['message'])) {
    $status_text = $sms_response['message'];
}

// For successful responses, try to extract message ID if available
if (isset($sms_response['data']) && is_array($sms_response['data'])) {
    $message_id = isset($sms_response['data'][0]['id']) ? $sms_response['data'][0]['id'] : '';
}

// Prepare response data (maintaining compatibility with old format)
$response_data = [
    'MessageID' => $message_id,
    'Status' => $error_code == 0 ? 1 : -1,
    'StatusText' => $status_text,
    'ErrorCode' => $error_code,
    'ErrorText' => $error_code != 0 ? $status_text : '',
    'SMSCount' => count($receivers),
    'CurrentCredit' => 0, // Not provided in new API
    'token' => $access_token,
    'refresh_token' => $refresh_token
];

// Log to database
// $query = 'INSERT INTO sms_api_info (cid, username, password, fromNumber, toNumber, message, status, ip_address) VALUES ("'.$cid.'","'.$username.'", "'.$password.'", "'.$from.'", "'.$to.'", "'.$message.'", "'.$status_text.'","'.$ip.'")';
// mysqli_query($new_conn, $query);

// Set HTTP status code
if ($error_code !== 0) {
    header("HTTP/1.1 " . $sms_result['http_code'] . " Error");
} else {
    header("HTTP/1.1 200 OK");
}

// Return response
echo json_encode($response_data);
?>