<?php
/**
 * Sample PHP client to send SMS using your API
 */

// Your API endpoint
 // Replace with your actual API URL

// Function to send SMS
function sendSMS($to, $message) {
    $api_url = 'https://cloudmvc.clouderp.com.bd/smsapi/smsapi.php';
    $from ='8801894650378';
    $cid='robi';
    $options=        [
            'msgType' => 'T',       // Transactional
            'contentType' => 1,     // Regular text
        ];
    // Default options
    $defaults = [
        'msgType' => 'T',        // T=transactional, P=promotional
        'contentType' => 1,      // 1=Regular, 2=Unicode
        'cid' => '',             // Customer ID
        'ip' => $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1'
    ];
    
    $options = array_merge($defaults, $options);
    
    // Prepare data
    $data = [
        'Username' => 'fahimerp',    // Your API username
        'Password' => '35ggh7',      // Your API password
        'From' => $from,
        'To' => $to,
        'Message' => $message,
        'msgType' => $options['msgType'],
        'contentType' => $options['contentType'],
        'cid' => $cid,
        'ip' => $options['ip']
    ];
    
    // Initialize cURL
    $curl = curl_init();
    
    curl_setopt_array($curl, [
        CURLOPT_URL => $api_url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Accept: application/json'
        ]
    ]);
    
    $response = curl_exec($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $error = curl_error($curl);
    
    curl_close($curl);
    
    if ($error) {
        return [
            'success' => false,
            'error' => 'cURL Error: ' . $error
        ];
    }
    
    $result = json_decode($response, true);
    
    if ($http_code === 200) {
        return [
            'success' => true,
            'data' => $result
        ];
    } else {
        return [
            'success' => false,
            'error' => 'HTTP Error: ' . $http_code,
            'response' => $result
        ];
    }
}

// Example usage
try {
    // Send single SMS
    $result = sendSMS(            // From (sender ID)
        '8801865482911',         // To (recipient number)
        'Hi this is fahim'
    );
    
    if ($result['success']) {
        echo "SMS sent successfully!\n";
        echo "Message ID: " . $result['data']['MessageID'] . "\n";
        echo "Status: " . $result['data']['StatusText'] . "\n";
        echo "SMS Count: " . $result['data']['SMSCount'] . "\n";
    } else {
        echo "Failed to send SMS: " . $result['error'] . "\n";
    }
    
    // Send bulk SMS (multiple recipients)
    // $bulk_result = sendSMS(
    //     'adaReach',
    //     '8801XXXXXXXXX,8801YYYYYYYYY,8801ZZZZZZZZZ',  // Multiple numbers
    //     'Bulk SMS message for all recipients',
    //     [
    //         'msgType' => 'P',       // Promotional
    //         'contentType' => 2,     // Unicode (required for promotional)
    //         'cid' => 'bulk001'
    //     ]
    // );
    
    // if ($bulk_result['success']) {
    //     echo "\nBulk SMS sent successfully!\n";
    //     echo "Status: " . $bulk_result['data']['StatusText'] . "\n";
    //     echo "SMS Count: " . $bulk_result['data']['SMSCount'] . "\n";
    // } else {
    //     echo "\nFailed to send bulk SMS: " . $bulk_result['error'] . "\n";
    // }
    
} catch (Exception $e) {
    echo "Exception: " . $e->getMessage() . "\n";
}

// Example with error handling


// Example with retry logic
// $retryResult = sendSMSWithRetry(
//     '8801894650378',
//     '8801865482911',
//     'Message with retry logic'
// );

// if ($retryResult['success']) {
//     echo "SMS sent with retry logic!\n";
// } else {
//     echo "Failed even with retry: " . $retryResult['error'] . "\n";
// }
?>